function [A, k, true_label, Pi, P, theta] = generate_network(bn,uni_1,uni_2,beta,beta2)

k = 6; 
n_0 = 5;
n_1 = 1.5;
n_2 = 6;
n_3 = 3;
n_4 = 7.5;
n_5 = 4;
N = 200* [ n_0, n_1, n_2, n_3,  n_4, n_5];
n = sum(N);


block_Pi= cell(1,k);
for i = 1:k 
    block_Pi{i} = ones(N(i),1);
end 

Pi = blkdiag(block_Pi{:});
true_label = [];
for i = 1:k
    true_label = [true_label; repmat(i, N(i), 1)];
end


theta_0 = uni_1 + (uni_2- uni_1) * rand(1, n);
bn = bn;
theta_0 = bn * theta_0 / sqrt(sum(theta_0.^2));  % Compute the scaled vector
theta = theta_0(randperm(length(theta_0)));

beta = beta;
 P = (1 - beta) * ones(k, k) + beta * eye(k);  % Construct matrix P

beta2 = beta2;
temp_P = kron(ones(2, 2)-eye(2), beta2*ones(k/2, k/2));
P = ( eye(k) + temp_P + P)/2 ;

tOmega = (Pi * P * Pi').* ( theta' * theta);  % Compute the true low-rank term (ensure element-wise multiplication)
Omega = tOmega ./ (1 + tOmega);

% Generate adjacency matrix 
A = rand(n,n);
A = A < Omega;
A = triu(A);
A = A + A';
A(1:length(A)+1:numel(A)) = 0; % diagonal of A set to be zero
% A = Omega;

end
